// Copyright ® 2025 OneSpan North America, Inc. All rights reserved. 

 
/////////////////////////////////////////////////////////////////////////////
//
//
// This file is example source code. It is provided for your information and
// assistance. See your licence agreement for details and the terms and
// conditions of the licence which governs the use of the source code. By using
// such source code you will be accepting these terms and conditions. If you do
// not wish to accept these terms and conditions, DO NOT OPEN THE FILE OR USE
// THE SOURCE CODE.
//
// Note that there is NO WARRANTY.
//
//////////////////////////////////////////////////////////////////////////////


import Combine
import MSSImageScanner

class MainViewModel: ObservableObject {
    // Scan result labels
    @Published var scanResultLabel = ""
    @Published var scanResultType  = ""
    @Published var scanResult: ScanResult?
    
    @Published var isShowingUIImagePickerSample = false
    @Published var isShowingUIKitSample = false
    @Published var isShowingSwiftUISample = false
    
    var cancellables: Set<AnyCancellable> = []
    
    init() {
        $scanResult.sink { result in
            guard let result else { return }
            self.showScanResult(result)
        }.store(in: &cancellables)
    }
    
    private func showScanResult(_ result: ScanResult) {
        switch result {
        case .scanned(let value, let codeType):
            scanResultLabel = value
            scanResultType  = codeType.title
            
        case .error(let error):
            guard let scannerError = error as? ScannerError else {
                assertionFailure("An error other than ScannerError is thrown: \(error)")
                return
            }
            scanResultLabel = "ScannerError: " + scannerError.localizedDescription
            scanResultType  = ""
            
        case .cancelled:
            scanResultLabel = "Scanning was cancelled"
            scanResultType  = ""
        }
    }
}
